﻿using System;
using System.Runtime.InteropServices;
using System.Text;
using System.Windows.Forms;

namespace PWS.API.Keyboard.Sample5
{
    public partial class FormMain : Form
    {
        public enum HKL
        {
            HKL_Prev = 0,
            HKL_Next = 1
        }

        [DllImport("user32.dll")]
        public static extern bool ActivateKeyboardLayout(HKL hkl, uint uFlags);

        [DllImport("user32.dll")]
        public static extern bool GetKeyboardLayoutName([Out] StringBuilder pwszKLID);

        [DllImport("kernel32.dll")]
        public static extern bool VerLanguageName(uint wLang, [Out] StringBuilder szLang, int wSize);

        public FormMain()
        {
            InitializeComponent();
        }

        private void buttonLanguage_Click(object sender, EventArgs e)
        {
            StringBuilder keyboardLayoutName = new StringBuilder(100);
            GetKeyboardLayoutName(keyboardLayoutName);
            StringBuilder languageName = new StringBuilder(100);
            VerLanguageName(1033, languageName, languageName.Capacity);
            MessageBox.Show(String.Format("LanguageCode = {0}, LanguageName = {1}", keyboardLayoutName, languageName));
            ActivateKeyboardLayout(HKL.HKL_Prev, 1);
        }
    }
}